<?php
namespace Tabs_For_Shortcodes;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Plugin {

    /**
     * Unica instancia del plugin.
     *
     * @var Plugin|null
     */
    private static $instance = null;

    /**
     * Retorna la instancia unica del plugin.
     */
    public static function instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * Constructor privado para aplicar el patron singleton.
     */
    private function __construct() {
        add_action( 'elementor/widgets/register', [ $this, 'register_widgets' ] );
        add_action( 'elementor/frontend/after_register_styles', [ $this, 'register_widget_styles' ] );
        add_action( 'elementor/frontend/after_register_scripts', [ $this, 'register_widget_scripts' ] );
    }

    /**
     * Registra las hojas de estilo del widget.
     */
    public function register_widget_styles() {
        wp_register_style(
            'tfs-shortcode-tabs',
            TFS_PLUGIN_URL . 'assets/css/tfs-shortcode-tabs.css',
            [],
            TFS_PLUGIN_VERSION
        );
    }

    /**
     * Registra los scripts del widget.
     */
    public function register_widget_scripts() {
        wp_register_script(
            'tfs-shortcode-tabs',
            TFS_PLUGIN_URL . 'assets/js/tfs-shortcode-tabs.js',
            [ 'elementor-frontend' ],
            TFS_PLUGIN_VERSION,
            true
        );
    }

    /**
     * Registra los widgets personalizados de Elementor.
     *
     * @param \Elementor\Widgets_Manager $widgets_manager Administrador de widgets de Elementor.
     */
    public function register_widgets( $widgets_manager ) {
        require_once TFS_PLUGIN_PATH . 'includes/widgets/class-tabs-shortcode-widget.php';

        $widgets_manager->register( new Widgets\Tabs_Shortcode_Widget() );
    }
}
