<?php
namespace Tabs_For_Shortcodes\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Tabs_Shortcode_Widget extends Widget_Base {

    public function get_name() {
        return 'tfs-shortcode-tabs';
    }

    public function get_title() {
        return __( 'Tabs de Shortcodes', 'tabs-for-shortcodes' );
    }

    public function get_icon() {
        return 'eicon-tabs';
    }

    public function get_categories() {
        return [ 'basic' ];
    }

    public function get_keywords() {
        return [ 'tabs', 'shortcode', 'contenedor', 'elementor' ];
    }

    public function get_style_depends() {
        return [ 'tfs-shortcode-tabs' ];
    }

    public function get_script_depends() {
        return [ 'tfs-shortcode-tabs' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_tabs',
            [
                'label' => __( 'Pestanas', 'tabs-for-shortcodes' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'tab_title',
            [
                'label' => __( 'Titulo', 'tabs-for-shortcodes' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Nueva pestana', 'tabs-for-shortcodes' ),
                'placeholder' => __( 'Introduce el titulo', 'tabs-for-shortcodes' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tab_shortcode',
            [
                'label' => __( 'Shortcode', 'tabs-for-shortcodes' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => '[mi_shortcode]',
                'rows' => 3,
            ]
        );

        $this->add_control(
            'tabs',
            [
                'label' => __( 'Elementos', 'tabs-for-shortcodes' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tab_title' => __( 'Pestana 1', 'tabs-for-shortcodes' ),
                        'tab_shortcode' => '',
                    ],
                    [
                        'tab_title' => __( 'Pestana 2', 'tabs-for-shortcodes' ),
                        'tab_shortcode' => '',
                    ],
                ],
                'title_field' => '{{{ tab_title }}}',
            ]
        );

        $this->add_control(
            'tabs_alignment',
            [
                'label' => __( 'Alineacion de pestanas', 'tabs-for-shortcodes' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => __( 'Izquierda', 'tabs-for-shortcodes' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Centro', 'tabs-for-shortcodes' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-end' => [
                        'title' => __( 'Derecha', 'tabs-for-shortcodes' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'flex-start',
                'toggle' => false,
            ]
        );

        $this->add_responsive_control(
            'tabs_gap',
            [
                'label' => __( 'Espacio entre pestanas', 'tabs-for-shortcodes' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tfs-tabs__nav' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_tabs',
            [
                'label' => __( 'Estilo de pestanas', 'tabs-for-shortcodes' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'tabs_text_color',
            [
                'label' => __( 'Color del texto', 'tabs-for-shortcodes' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tfs-tabs__nav-button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tabs_active_text_color',
            [
                'label' => __( 'Color activo', 'tabs-for-shortcodes' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tfs-tabs__nav-button.is-active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tabs_background_color',
            [
                'label' => __( 'Fondo', 'tabs-for-shortcodes' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tfs-tabs__nav-button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tabs_active_background_color',
            [
                'label' => __( 'Fondo activo', 'tabs-for-shortcodes' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tfs-tabs__nav-button.is-active' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tabs_typography',
                'selector' => '{{WRAPPER}} .tfs-tabs__nav-button',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tabs_border',
                'selector' => '{{WRAPPER}} .tfs-tabs__nav-button',
            ]
        );

        $this->add_responsive_control(
            'tabs_border_radius',
            [
                'label' => __( 'Radio del borde', 'tabs-for-shortcodes' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .tfs-tabs__nav-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tabs_padding',
            [
                'label' => __( 'Relleno', 'tabs-for-shortcodes' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .tfs-tabs__nav-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_content',
            [
                'label' => __( 'Estilo del contenido', 'tabs-for-shortcodes' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'content_background_color',
            [
                'label' => __( 'Fondo', 'tabs-for-shortcodes' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tfs-tabs__panel' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} .tfs-tabs__panel',
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __( 'Relleno', 'tabs-for-shortcodes' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .tfs-tabs__panel' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $tabs = isset( $settings['tabs'] ) ? $settings['tabs'] : [];

        if ( empty( $tabs ) ) {
            return;
        }

        $widget_uid = 'tfs-tabs-' . $this->get_id();
        $alignment = ! empty( $settings['tabs_alignment'] ) ? $settings['tabs_alignment'] : 'flex-start';
        ?>
        <div class="tfs-tabs" id="<?php echo esc_attr( $widget_uid ); ?>">
            <div class="tfs-tabs__nav" role="tablist" style="justify-content: <?php echo esc_attr( $alignment ); ?>;">
                <?php foreach ( $tabs as $index => $tab ) :
                    $tab_id = $widget_uid . '-tab-' . $index;
                    $panel_id = $widget_uid . '-panel-' . $index;
                    $title = ! empty( $tab['tab_title'] ) ? $tab['tab_title'] : sprintf( __( 'Pestana %d', 'tabs-for-shortcodes' ), $index + 1 );
                    $is_active = 0 === $index;
                    ?>
                    <button
                        class="tfs-tabs__nav-button<?php echo $is_active ? ' is-active' : ''; ?>"
                        id="<?php echo esc_attr( $tab_id ); ?>"
                        type="button"
                        role="tab"
                        data-tfs-tab-target="<?php echo esc_attr( $panel_id ); ?>"
                        aria-controls="<?php echo esc_attr( $panel_id ); ?>"
                        aria-selected="<?php echo $is_active ? 'true' : 'false'; ?>"
                    >
                        <?php echo esc_html( $title ); ?>
                    </button>
                <?php endforeach; ?>
            </div>
            <div class="tfs-tabs__content">
                <?php foreach ( $tabs as $index => $tab ) :
                    $panel_id = $widget_uid . '-panel-' . $index;
                    $tab_id = $widget_uid . '-tab-' . $index;
                    $shortcode = isset( $tab['tab_shortcode'] ) ? $tab['tab_shortcode'] : '';
                    $is_active = 0 === $index;
                    ?>
                    <div
                        class="tfs-tabs__panel<?php echo $is_active ? ' is-active' : ''; ?>"
                        id="<?php echo esc_attr( $panel_id ); ?>"
                        role="tabpanel"
                        aria-labelledby="<?php echo esc_attr( $tab_id ); ?>"
                        data-tfs-tab-panel
                    >
                        <?php
                        if ( ! empty( $shortcode ) ) {
                            echo do_shortcode( $shortcode );
                        }
                        ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
    }
}
