<?php
/**
 * Plugin Name: Tabs for Shortcodes
 * Description: Proporciona un widget de Elementor para mostrar shortcodes dentro de pestanas.
 * Version: 1.0.0
 * Author: Santiago Leston
 * Text Domain: tabs-for-shortcodes
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'TFS_PLUGIN_VERSION', '1.0.0' );
define( 'TFS_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'TFS_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'TFS_MINIMUM_ELEMENTOR_VERSION', '3.0.0' );

function tfs_load_textdomain() {
    load_plugin_textdomain( 'tabs-for-shortcodes', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
}
add_action( 'init', 'tfs_load_textdomain' );

function tfs_plugin_init() {
    if ( ! did_action( 'elementor/loaded' ) ) {
        add_action( 'admin_notices', 'tfs_admin_notice_missing_elementor' );
        return;
    }

    if ( ! defined( 'ELEMENTOR_VERSION' ) || version_compare( ELEMENTOR_VERSION, TFS_MINIMUM_ELEMENTOR_VERSION, '<' ) ) {
        add_action( 'admin_notices', 'tfs_admin_notice_minimum_elementor' );
        return;
    }

    if ( version_compare( PHP_VERSION, '7.4', '<' ) ) {
        add_action( 'admin_notices', 'tfs_admin_notice_minimum_php' );
        return;
    }

    require_once TFS_PLUGIN_PATH . 'includes/class-tabs-for-shortcodes.php';

    \Tabs_For_Shortcodes\Plugin::instance();
}
add_action( 'plugins_loaded', 'tfs_plugin_init' );

function tfs_admin_notice_missing_elementor() {
    if ( isset( $_GET['activate'] ) ) {
        unset( $_GET['activate'] );
    }

    $message = sprintf(
        esc_html__( '"%1$s" requiere que Elementor este activo. Por favor, instala y activa Elementor.', 'tabs-for-shortcodes' ),
        '<strong>' . esc_html__( 'Tabs for Shortcodes', 'tabs-for-shortcodes' ) . '</strong>'
    );

    printf( '<div class="notice notice-warning"><p>%s</p></div>', $message );
}

function tfs_admin_notice_minimum_elementor() {
    if ( isset( $_GET['activate'] ) ) {
        unset( $_GET['activate'] );
    }

    $message = sprintf(
        esc_html__( '"%1$s" requiere Elementor %2$s o superior.', 'tabs-for-shortcodes' ),
        '<strong>' . esc_html__( 'Tabs for Shortcodes', 'tabs-for-shortcodes' ) . '</strong>',
        TFS_MINIMUM_ELEMENTOR_VERSION
    );

    printf( '<div class="notice notice-warning"><p>%s</p></div>', $message );
}

function tfs_admin_notice_minimum_php() {
    if ( isset( $_GET['activate'] ) ) {
        unset( $_GET['activate'] );
    }

    $message = sprintf(
        esc_html__( '"%1$s" requiere una version de PHP igual o superior a %2$s.', 'tabs-for-shortcodes' ),
        '<strong>' . esc_html__( 'Tabs for Shortcodes', 'tabs-for-shortcodes' ) . '</strong>',
        '7.4'
    );

    printf( '<div class="notice notice-warning"><p>%s</p></div>', $message );
}
